#! perl -w

# +------------------------------------------------------------------------+
# | Licensed Materials - Property of IBM                                   |
# |                                                                        |
# | com.ibm.xtools.umldt.rt.core.tools                                     |
# |                                                                        |
# | Copyright IBM Corporation 1999, 2011.  All Rights Reserved.            |
# |                                                                        |
# | U.S. Government Users Restricted Rights - Use, duplication or          |
# | disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      |
# +------------------------------------------------------------------------+

# rtcppdep.pl - Dependency updater

sub fatal($)
{
	print STDERR "rtcppdep.pl: ", @_, "\n";
	exit 1;
}

sub find_file($)
{
	my( $file ) = @_;
	my( $path );

	# a special case: has a complete path already been provided?
	return $file if -e "$file";

	foreach $loc ( @deppath )
	{
		$path = "$loc/$file";
		return $path if -e $path;
	}

	return '';
}

# Get the arguments

$depfile = '';
@deppath = ();
$depvar  = '';
$escape  = 'fail';
$srcfile = '';

&fatal( 'Usage input macro output [options]' )
	unless( $#ARGV >= 2 );

$srcfile = shift @ARGV;
$depvar  = shift @ARGV;
$depfile = shift @ARGV;

while( $#ARGV >= 0 )
{
	$arg = shift @ARGV;
	if( $arg eq '-E' )
	{
		$escape = shift @ARGV;
	}
	elsif( $arg eq '-I' )
	{
		@deppath = @ARGV;
		last;
	}
	else
	{
		&fatal( "Unknown option '" . $arg . "'" );
	}
}

# use forward slashes exclusively
$srcfile =~ s{\\}{/}g;
foreach $loc ( @deppath )
{
	$loc =~ s{\\}{/}g;
}

@deplist = ( $srcfile );
$deps{$srcfile} = 1;

foreach $file ( @deplist )
{
	&fatal( "cannot open '$file'" )
		unless( open FILE, $file );

	while( <FILE> )
	{
		# recognize: include <X> or include "X"
		if( m{^\s*#\s*include\s*\<([^\>]*)\>} or
			m{^\s*#\s*include\s*\"([^\"]*)\"} )
		{
			my( $include ) = &find_file( $1 );

			if( $include && ! $deps{$include} )
			{
				$deps{$include} = 1;
				push @deplist, $include;
			}
		}
	}

	close FILE;
}

if( $escape eq 'bs' )
{
	foreach $dep ( @deplist )
	{
		$dep =~ s{\s}{\\$&}g;
	}
}
elsif( $escape eq 'dq' )
{
	foreach $dep ( @deplist )
	{
		$dep =~ s{^.*\s.*$}{"$&"};
	}
}
else
{
	foreach $dep ( @deplist )
	{
		if( $dep =~ m{\s} )
		{
			&fatal( "Whitespace in path '$dep' not supported." );
		}
	}
}

&fatal( "cannot write to '$depfile'" )
	unless( open DEPFILE, ">$depfile" );

binmode( DEPFILE );

print DEPFILE $depvar, " =";

foreach $dep ( @deplist )
{
	print DEPFILE " \\\n\t", $dep;
}

print DEPFILE "\n";

close DEPFILE;

exit 0;
