/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.art.export.diagrams.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hcl.art.export.diagrams.actions.CustomElementPropertyModel;
import com.hcl.art.export.diagrams.actions.ExportStateMachineDiagramData;
import com.hcl.art.integration.core.exporter.ArtGenerator;
import com.hcl.art.integration.core.exporter.IElementCPPPropertyModel;
import com.hcl.art.integration.core.util.ArtExportUtil;
import com.hcl.rtistic.art.artlang.NamedElement;
import com.hcl.rtistic.art.diagrams.ArtDiagramType;
import com.hcl.rtistic.art.diagrams.LayoutSettings;
import com.hcl.rtistic.art.diagrams.LayoutSettingsJsonSerializer;
import com.hcl.uml.rt.common.utils.UMLRTProfileCommon;
import com.hcl.xtools.modelcompiler.common.messages.MessageList;
import com.hcl.xtools.modelcompiler.common.utils.TextHelper;
import com.hcl.xtools.transform.tcjs.TCJS;
import com.hcl.xtools.transform.tcjs.api.IJSTransformConfiguration;
import com.hcl.xtools.transform.tcjs.server.ModelCompilerCall;
import com.ibm.xtools.modelcompiler.common.utils.RTUtils;
import com.ibm.xtools.modeler.ui.internal.ModelerPlugin;
import com.ibm.xtools.transform.core.metatype.EObjectReference;
import com.ibm.xtools.uml.msl.internal.operations.NamespaceOperations;
import com.ibm.xtools.umldt.ui.dialogs.MCConsole;
import com.ibm.xtools.umlnotation.UMLDiagramKind;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.core.edit.MEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.StateMachine;

public class ExportDiagramsAction {
    public Map<String, LayoutSettings> layoutSettingsMap = new HashMap<String, LayoutSettings>();

    public void run(final IFile file, final String destinationPath, final List<ModelCompilerCall.IResultDetails> result) {
        Job job = new Job("Exporting diagram layouts..."){

            protected IStatus run(IProgressMonitor monitor) {
                return ExportDiagramsAction.this.exportDiagrams(file, destinationPath, result);
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.setPriority(30);
        job.schedule();
    }

    public IStatus exportDiagrams(IFile file, String destinationPath, List<ModelCompilerCall.IResultDetails> result) {
        Map sourcesMap;
        boolean brokenRefDialogPref = ModelerPlugin.getInstance().getPreferenceStore().getBoolean("warn_broken_references");
        ModelerPlugin.getInstance().getPreferenceStore().setValue("warn_broken_references", false);
        MCConsole.log((String)(this.timePrefix() + ": Exporting diagram layouts..."), (Object[])new Object[0]);
        List evaluate = TCJS.evaluate((java.nio.file.Path)file.getLocation().toPath(), null, null);
        IJSTransformConfiguration transformConfiguration = (IJSTransformConfiguration)evaluate.get(0);
        Object sourcesObj = transformConfiguration.get((Object)"sources");
        Map map = sourcesMap = sourcesObj instanceof Map ? (Map)sourcesObj : null;
        if (sourcesMap == null) {
            return Status.CANCEL_STATUS;
        }
        Collection sources = sourcesMap.values();
        HashSet<EObject> sourceElements = new HashSet<EObject>();
        for (Object source : sources) {
            if (!(source instanceof String)) continue;
            URI uri = URI.createURI((String)((String)source));
            EObject element = MEditingDomain.getInstance().getResourceSet().getEObject(uri, true);
            if (element == null) continue;
            this.updateSourceElements(element, sourceElements);
        }
        this.addMissingDependencies(sourceElements, result);
        this.convertToArt(sourceElements, destinationPath);
        this.extractDiagramData(sourceElements);
        boolean layoutsExported = !this.layoutSettingsMap.isEmpty();
        try {
            this.createLayoutSettingsFiles(destinationPath);
        }
        catch (IOException iOException) {
            MCConsole.log((String)(this.timePrefix() + ": Diagram layout export failed."), (Object[])new Object[0]);
            return Status.CANCEL_STATUS;
        }
        if (layoutsExported) {
            MCConsole.log((String)(this.timePrefix() + ": Diagram layout export completed successfully."), (Object[])new Object[0]);
        }
        ArtGenerator.getInstance().clearCache();
        ModelerPlugin.getInstance().getPreferenceStore().setValue("warn_broken_references", brokenRefDialogPref);
        return Status.OK_STATUS;
    }

    private void addMissingDependencies(Set<EObject> sourceElements, List<ModelCompilerCall.IResultDetails> result) {
        if (result == null || result.isEmpty()) {
            return;
        }
        result.stream().map(s -> (ModelCompilerCall.SourceDetails)s).filter(s -> s.isMissing).forEach(s -> {
            EObject element = EObjectReference.resolveExclusively((String)s.elementURI, (boolean)true);
            if (element instanceof Element) {
                this.updateSourceElements(element, sourceElements);
            }
        });
    }

    private String timePrefix() {
        Date date = new Date(System.currentTimeMillis());
        return TextHelper.TIME_FORMAT.format(date);
    }

    private void convertToArt(Set<EObject> sourceElements, String destinationPath) {
        ArrayList<CustomElementPropertyModel> elements = new ArrayList<CustomElementPropertyModel>();
        for (EObject sourceElement : sourceElements) {
            elements.add(new CustomElementPropertyModel(sourceElement, destinationPath));
        }
        ArtGenerator.getInstance().generateArt(elements, new MessageList());
        HashSet<CallSite> artFileNamesToDelete = new HashSet<CallSite>();
        for (IElementCPPPropertyModel iElementCPPPropertyModel : elements) {
            EObject eObject = iElementCPPPropertyModel.getElement();
            if (!ArtExportUtil.isArtExportSupported((EObject)eObject)) continue;
            artFileNamesToDelete.add((CallSite)((Object)(RTUtils.getName((EObject)eObject) + ".art")));
        }
        File file = new File(destinationPath);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.isFile() && artFileNamesToDelete.contains(file2.getName())) {
                    file2.delete();
                }
                ++n2;
            }
        }
    }

    private void createLayoutSettingsFiles(String destinationPath) throws IOException {
        for (Map.Entry<String, LayoutSettings> iterable_element : this.layoutSettingsMap.entrySet()) {
            String fileName = iterable_element.getKey();
            LayoutSettings layoutSettings = iterable_element.getValue();
            this.writeLayoutSettingsToFile(destinationPath, fileName, layoutSettings);
        }
    }

    private void writeLayoutSettingsToFile(String destinationPath, String fileName, LayoutSettings layoutSettings) throws IOException {
        java.nio.file.Path layoutSettingsFile = Paths.get(destinationPath + "/" + fileName, new String[0]);
        layoutSettingsFile.getParent().toFile().mkdirs();
        File file = new File(layoutSettingsFile.toString());
        boolean settingsFileAvailable = true;
        if (!file.exists()) {
            settingsFileAvailable = file.createNewFile();
        }
        if (!settingsFileAvailable) {
            return;
        }
        ArrayList<LayoutSettings> layoutSettingsList = new ArrayList<LayoutSettings>();
        layoutSettingsList.add(layoutSettings);
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Collection.class, (Object)new LayoutSettingsJsonSerializer()).create();
        Type listType = new TypeToken<ArrayList<LayoutSettings>>(){}.getType();
        String strJson = gson.toJson(layoutSettingsList, listType);
        PrintWriter out = new PrintWriter(layoutSettingsFile.toString());
        out.write(strJson);
        out.flush();
        out.close();
    }

    private void extractDiagramData(Set<EObject> sourceElements) {
        for (EObject sourceElement : sourceElements) {
            StateMachine stateMachine;
            this.updateLayoutSettings(sourceElement, sourceElement, NamespaceOperations.getOwnedDiagrams((Namespace)((Namespace)sourceElement), (boolean)false));
            if (!RTUtils.isPassiveClass((EObject)sourceElement) && !RTUtils.isCapsule((EObject)sourceElement) || (stateMachine = RTUtils.getStateMachine((Class)((Class)sourceElement))) == null) continue;
            this.updateLayoutSettings(sourceElement, (EObject)stateMachine, NamespaceOperations.getOwnedDiagrams((Namespace)stateMachine, (boolean)false));
        }
    }

    private void updateLayoutSettings(EObject sourceElement, EObject elementContainingDiagram, List<Diagram> ownedDiagrams) {
        for (Diagram diagram : ownedDiagrams) {
            if (UMLDiagramKind.STRUCTURE_LITERAL.getLiteral().equals(diagram.getType())) {
                this.exportStructureDiagramToJSON(sourceElement, elementContainingDiagram, diagram);
                continue;
            }
            if (!UMLDiagramKind.STATECHART_LITERAL.getLiteral().equals(diagram.getType())) continue;
            this.exportStateChartToJSON(sourceElement, elementContainingDiagram, diagram);
        }
    }

    private void exportStructureDiagramToJSON(EObject sourceElement, EObject elementContainingDiagram, Diagram diagram) {
    }

    private void exportStateChartToJSON(EObject sourceElement, EObject elementContainingDiagram, Diagram diagram) {
        EObject artElement = ArtGenerator.getInstance().getArtElementsCache().getArtElement(sourceElement);
        LayoutSettings layoutSettings = new ExportStateMachineDiagramData().getLayoutSettings(sourceElement, diagram, artElement);
        String name = this.getElementName(artElement);
        if (name == null || name.isEmpty() || layoutSettings == null || layoutSettings.layouts.isEmpty()) {
            return;
        }
        this.layoutSettingsMap.put(ExportDiagramsAction.getProjectNameFromEObject(sourceElement) + "/layouts/" + name + "-" + name + "-" + ArtDiagramType.STATE_DIAGRAM.getShortDiagramName() + ".json", layoutSettings);
    }

    private String getElementName(EObject artElement) {
        if (artElement instanceof NamedElement) {
            return ((NamedElement)artElement).getName();
        }
        return RTUtils.getName((EObject)artElement);
    }

    private void updateSourceElements(EObject element, Set<EObject> sourceElements) {
        if (element instanceof Package) {
            EList packagedElements = ((Package)element).getPackagedElements();
            for (EObject eObject : packagedElements) {
                this.updateSourceElements(eObject, sourceElements);
            }
        } else if (element instanceof Element && (UMLRTProfileCommon.isCapsule((Element)((Element)element)) || element instanceof Class)) {
            sourceElements.add(element);
        }
    }

    public static String getProjectNameFromEObject(EObject eObject) {
        if (eObject == null || eObject.eResource() == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        URI uri = resource.getURI();
        if (uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
            IProject project = file.getProject();
            return project.getName();
        }
        return null;
    }
}

